// PageSettingShow.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingShow.h"


// CLS_PageSettingShow dialog

IMPLEMENT_DYNAMIC(CLS_PageSettingShow, CDialog)

CLS_PageSettingShow::CLS_PageSettingShow(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CLS_PageSettingShow::IDD, pParent)
{
	m_iLogonID = -1;
}

CLS_PageSettingShow::~CLS_PageSettingShow()
{
}

void CLS_PageSettingShow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_CHANNEL, m_cboOutputChannel);
	DDX_Control(pDX, IDC_CHECK_REGION_ENABLE, m_chkShowRegionEnable);
	DDX_Control(pDX, IDC_EDIT_REGION_X_POSITION, m_edtRegionPosition_X);
	DDX_Control(pDX, IDC_EDIT_REGION_Y_POSITION, m_edtRegionPosition_Y);
	DDX_Control(pDX, IDC_EDIT_REGION_PIXEL_WIDTH, m_edtRegionPixelWidth);
	DDX_Control(pDX, IDC_EDIT_REGION_PIXEL_HEIGHT, m_edtRegionPixelHeight);
	DDX_Control(pDX, IDC_EDIT_SHOW_PARA_Brightness, m_edtBrightness);
	DDX_Control(pDX, IDC_EDIT_SHOW_PARA_Contrast, m_edtContrast);
	DDX_Control(pDX, IDC_EDIT_SHOW_PARA_Saturation, m_edtSaturation);
	DDX_Control(pDX, IDC_EDIT_SHOW_PARA_Hue, m_edtHue);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_CHANNEL_BY_PARA, m_cboOutputChannelByPara);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_MODE, m_cboOutputMode);
	DDX_Control(pDX, IDC_COMBO_OUTPUT_CHANNEL_MODE, m_cboOutputChanMode);
}


BEGIN_MESSAGE_MAP(CLS_PageSettingShow, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_SET_SHOW_REGION, &CLS_PageSettingShow::OnBnClickedButtonSetShowRegion)
	ON_BN_CLICKED(IDC_BUTTON_SET_SHOW_PARA, &CLS_PageSettingShow::OnBnClickedButtonSetShowPara)
	ON_WM_SHOWWINDOW()
	ON_CBN_SELCHANGE(IDC_COMBO_OUTPUT_CHANNEL, &CLS_PageSettingShow::OnCbnSelchangeComboOutputChannel)
	ON_CBN_SELCHANGE(IDC_COMBO_OUTPUT_CHANNEL_BY_PARA, &CLS_PageSettingShow::OnCbnSelchangeComboOutputChannelByPara)
	ON_BN_CLICKED(IDC_BUTTON_SET_OUTPUT_MODE, &CLS_PageSettingShow::OnBnClickedButtonSetOutputMode)
	ON_CBN_SELCHANGE(IDC_COMBO_OUTPUT_CHANNEL_MODE, &CLS_PageSettingShow::OnCbnSelchangeComboOutputChannelMode)
END_MESSAGE_MAP()


// CLS_PageSettingShow message handlers

BOOL CLS_PageSettingShow::OnInitDialog()
{
	CLS_CBasePage::OnInitDialog();

	// TODO:  Add extra initialization here
	m_edtRegionPosition_X.SetLimitText(DEC_LEN_16);
	m_edtRegionPosition_Y.SetLimitText(DEC_LEN_16);
	m_edtRegionPixelWidth.SetLimitText(DEC_LEN_16);
	m_edtRegionPixelHeight.SetLimitText(DEC_LEN_16);
	m_edtBrightness.SetLimitText(DEC_LEN_16);
	m_edtContrast.SetLimitText(DEC_LEN_16);
	m_edtSaturation.SetLimitText(DEC_LEN_16);
	m_edtHue.SetLimitText(DEC_LEN_16);

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CLS_PageSettingShow::SetLogonID(LONG _iLogonID)
{
	m_iLogonID = _iLogonID;
}

BOOL CLS_PageSettingShow::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CLS_PageSettingShow::OnParamChangeNotify(_CHANGE_PARAM_NOTIFY_DATA* pData)
{
	switch(pData->m_iMsg)
	{
	case DEC_PARACHANGE_SCREEN_REGION:
		{
			UpdateShowRegion();
		}
		break;
	case DEC_PARACHANGE_SCREEN_BASICPARA:
		{
			UpdateShowBasicPara();
		}
		break;
	default:
		break;
	}
}

void CLS_PageSettingShow::UpdateShowRegion()
{
	int iOutputChanNo = GetComboData(&m_cboOutputChannel);
	if (EX_CHANNEL_FLAG == iOutputChanNo)
	{
		iOutputChanNo = 0;
	}
	DecScreenRegion tScreenRegion = {0};
	tScreenRegion.iSize = sizeof(DecScreenRegion);
	int iRet = DEC_ClientGetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_REGION, &tScreenRegion, sizeof(DecScreenRegion));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::UpdateShowRegion][DEC_ClientGetDevConfig:CMD_DEC_CFG_SCREEN_REGION] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
	else
	{
		m_chkShowRegionEnable.SetCheck(tScreenRegion.iEnable);
		SetDlgItemInt(IDC_EDIT_REGION_X_POSITION, tScreenRegion.iXPos);
		SetDlgItemInt(IDC_EDIT_REGION_Y_POSITION, tScreenRegion.iYPos);
		SetDlgItemInt(IDC_EDIT_REGION_PIXEL_WIDTH, tScreenRegion.iPixelWidth);
		SetDlgItemInt(IDC_EDIT_REGION_PIXEL_HEIGHT, tScreenRegion.iPixelHeight);
	}
}

void CLS_PageSettingShow::OnBnClickedButtonSetShowRegion()
{
	int iOutputChanNo = GetComboData(&m_cboOutputChannel);
	DecScreenRegion tScreenRegion = {0};
	tScreenRegion.iSize = sizeof(DecScreenRegion);
	tScreenRegion.iEnable = m_chkShowRegionEnable.GetCheck();
	tScreenRegion.iXPos = GetDlgItemInt(IDC_EDIT_REGION_X_POSITION);
	tScreenRegion.iYPos = GetDlgItemInt(IDC_EDIT_REGION_Y_POSITION);
	tScreenRegion.iPixelWidth = GetDlgItemInt(IDC_EDIT_REGION_PIXEL_WIDTH);
	tScreenRegion.iPixelHeight = GetDlgItemInt(IDC_EDIT_REGION_PIXEL_HEIGHT);
	int iRet = DEC_ClientSetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_REGION, &tScreenRegion, sizeof(DecScreenRegion));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::OnBnClickedButtonSetShowRegion][DEC_ClientSetDevConfig:CMD_DEC_CFG_SCREEN_REGION] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
}

void CLS_PageSettingShow::UpdateShowBasicPara()
{
	int iIndex = m_cboOutputChannelByPara.GetCurSel();
	int iOutputChanNo = m_cboOutputChannelByPara.GetItemData(iIndex);
	if (EX_CHANNEL_FLAG == iOutputChanNo)
	{
		iOutputChanNo = 0;
	}
	DecScreenBasicPara tScreenBasicPara = {0};
	tScreenBasicPara.iSize = sizeof(DecScreenBasicPara);
	int iRet = DEC_ClientGetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_BASICPARA, &tScreenBasicPara, sizeof(DecScreenBasicPara));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::UpdateShowBasicPara][DEC_ClientGetDevConfig:CMD_DEC_CFG_SCREEN_BASICPARA] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
	else
	{
		SetDlgItemInt(IDC_EDIT_SHOW_PARA_Brightness, tScreenBasicPara.iBrightness);
		SetDlgItemInt(IDC_EDIT_SHOW_PARA_Contrast, tScreenBasicPara.iContrast);
		SetDlgItemInt(IDC_EDIT_SHOW_PARA_Saturation, tScreenBasicPara.iSaturation);
		SetDlgItemInt(IDC_EDIT_SHOW_PARA_Hue, tScreenBasicPara.iHue);
	}
}

void CLS_PageSettingShow::OnBnClickedButtonSetShowPara()
{
	int iIndex = m_cboOutputChannelByPara.GetCurSel();
	int iOutputChanNo = m_cboOutputChannelByPara.GetItemData(iIndex);
	DecScreenBasicPara tScreenBasicPara = {0};
	tScreenBasicPara.iSize = sizeof(DecScreenBasicPara);
	tScreenBasicPara.iBrightness = GetDlgItemInt(IDC_EDIT_SHOW_PARA_Brightness);
	tScreenBasicPara.iContrast = GetDlgItemInt(IDC_EDIT_SHOW_PARA_Contrast);
	tScreenBasicPara.iSaturation = GetDlgItemInt(IDC_EDIT_SHOW_PARA_Saturation);
	tScreenBasicPara.iHue = GetDlgItemInt(IDC_EDIT_SHOW_PARA_Hue);
	int iRet = DEC_ClientSetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_BASICPARA, &tScreenBasicPara, sizeof(DecScreenBasicPara));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::OnBnClickedButtonSetShowPara][DEC_ClientSetDevConfig:CMD_DEC_CFG_SCREEN_BASICPARA] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
}

void CLS_PageSettingShow::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CLS_CBasePage::OnShowWindow(bShow, nStatus);
	if (bShow)
	{
		m_cboOutputChannel.ResetContent();
		m_cboOutputChannelByPara.ResetContent();
		m_cboOutputChanMode.ResetContent();


		CreateChannelCombo(m_iLogonID, &m_cboOutputChannel);
		int iIndex = m_cboOutputChannel.AddString("ͨ");
		m_cboOutputChannel.SetItemData(iIndex, EX_CHANNEL_FLAG);


		bool blUsedChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM] = {false};
		bool blUsedScreen[DEC_MAX_SPLIT_CHANNEL_NUM] = {false};
		int iUsedScreen = 0;
		int iUsedChannel = 0;
		int iRet = CheckChannel(m_iLogonID, blUsedChannel, &iUsedChannel, blUsedScreen, &iUsedScreen, -1);
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		}
		CString strChanel;
		tDevInfo tDevInfomation = {0};
		iRet = DEC_ClientGetDevConfig(m_iLogonID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
		if(iRet < 0)
		{
			AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
			return;
		}
		int iIndexSysChannel = 0;
		for (int i=0; i<tDevInfomation.iChanNum; ++i)
		{
			if (!blUsedChannel[i])
			{
				strChanel.Format(_T("%s%d"),GetText(IDS_MAIN_CHANNEL),i + 1);
				iIndexSysChannel = m_cboOutputChannelByPara.AddString(strChanel);
				m_cboOutputChannelByPara.SetItemData(iIndexSysChannel, i);
			}
		}
		iIndexSysChannel = m_cboOutputChannelByPara.AddString("ͨ");
		m_cboOutputChannelByPara.SetItemData(iIndexSysChannel, EX_CHANNEL_FLAG);
		m_cboOutputChannelByPara.SetCurSel(0);


		CreateChannelCombo(m_iLogonID, &m_cboOutputChanMode);
		iIndex = m_cboOutputChanMode.AddString("ͨ");
		m_cboOutputChanMode.SetItemData(iIndex, EX_CHANNEL_FLAG);


		m_cboOutputMode.ResetContent();
		iIndex = m_cboOutputMode.AddString("HDMI");
		m_cboOutputMode.SetItemData(iIndex, SCREEN_OUTPUT_MODE_HDMI);
		iIndex = m_cboOutputMode.AddString("DVI");
		m_cboOutputMode.SetItemData(iIndex, SCREEN_OUTPUT_MODE_DVI);
		iIndex = m_cboOutputMode.AddString("Ӧ");
		m_cboOutputMode.SetItemData(iIndex, SCREEN_OUTPUT_MODE_ADAPTATION);

		UpdateShowRegion();
		UpdateShowBasicPara();
		UpdateScreenOutputMode();
	}
}

void CLS_PageSettingShow::OnCbnSelchangeComboOutputChannel()
{
	UpdateShowRegion();
}

void CLS_PageSettingShow::OnCbnSelchangeComboOutputChannelByPara()
{
	UpdateShowBasicPara();
}

void CLS_PageSettingShow::UpdateScreenOutputMode()
{
	int iOutputChanNo = GetComboData(&m_cboOutputChanMode);
	if (EX_CHANNEL_FLAG == iOutputChanNo)
	{
		iOutputChanNo = 0;
	}
	DecScreenOutputMode tScreenOutputMode  = {0};
	tScreenOutputMode.iSize = sizeof(DecScreenOutputMode);
	int iRet = DEC_ClientGetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_OUTPUT_MODE, &tScreenOutputMode, sizeof(DecScreenOutputMode));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::UpdateScreenOutputMode][DEC_ClientGetDevConfig:CMD_DEC_CFG_SCREEN_OUTPUT_MODE] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
	else
	{
		m_cboOutputMode.SetCurSel(tScreenOutputMode.iMode);
	}
}

void CLS_PageSettingShow::OnBnClickedButtonSetOutputMode()
{
	int iIndex = m_cboOutputChanMode.GetCurSel();
	int iOutputChanNo = m_cboOutputChanMode.GetItemData(iIndex);
	DecScreenOutputMode tScreenOutputMode = {0};
	tScreenOutputMode.iSize = sizeof(DecScreenOutputMode);
	tScreenOutputMode.iMode = m_cboOutputMode.GetCurSel();
	int iRet = DEC_ClientSetDevConfig(m_iLogonID, iOutputChanNo, 0, CMD_DEC_CFG_SCREEN_OUTPUT_MODE, &tScreenOutputMode, sizeof(DecScreenOutputMode));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CLS_PageSettingShow::OnBnClickedButtonSetOutputMode][DEC_ClientSetDevConfig:CMD_DEC_CFG_SCREEN_OUTPUT_MODE] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),m_iLogonID);
	}
}

void CLS_PageSettingShow::OnCbnSelchangeComboOutputChannelMode()
{
	UpdateScreenOutputMode();
}
